import threading
import requests
import json

class client:
	
	def __init__(this, url):
		this.url = url
		this.thread = None
		this.queue = ""
		this.queue_lock = threading.Lock()
		this.log = None
		this.aver = None
		this.status = None
		this.status_last = None
		this.status_lock = threading.Lock()
		this.tk_element = None
	
	def status_set(this, txt):
		with this.status_lock:
			if txt != this.status_last:
				this.status_last = txt
				this.status = txt
				if this.tk_element:
					this.tk_element.event_generate("<<INTRA_Status>>", when="tail")
	
	def status_pop(this):
		with this.status_lock:
			txt = this.status
			this.status = None
			return txt
	
	def task(this, t):
		s = requests.Session()
		this.xfer(s, "")
		while t.task_run:
			dat = ""
			with this.queue_lock:
				dat = this.queue
				this.queue = ""
			if dat:
				this.xfer(s, dat)
			t.task_interrupt.wait(10)
		try:
			s.close()
		except:
			pass
	
	def xfer(this, s, dat):
		res = s.post(this.url, data=dat)
		try:
			msg = res.json()
			this.status_set(str(msg['status']))
			this.aver = int(msg['aver'])
		except:
			this.status_set("Protocol error")
	
	def up(this):
		this.down()
		t = threading.Thread(target=client.task)
		t._args = (this, t)
		t.task_interrupt = threading.Event()
		t.task_run = True
		this.thread = t;
		t.start()
	
	def down(this):
		if this.thread:
			this.thread.task_run = False
			this.thread.task_interrupt.set()
		this.thread = None
		this.queue = ""
	
	def ln(this, txt):
		if this.thread and txt:
			if txt[-1] != "\n": txt += "\n"
			with this.queue_lock:
				this.queue += txt
	
	def json(this, obj):
		this.ln(json.dumps(obj))
	
