import sys
import os
import logging
import random
import string
from config import appname

import tkinter as tk
from tkinter import ttk

try:
	sys.path.insert(0, os.path.dirname(__file__))
	from client import client
finally:
	del sys.path[0]

plugin_name = "INTRA"
plugin_ver = 1
status_prefix = f"{plugin_name} v{plugin_ver}:";
com = client("https://iniv.space/intra/com/")

log = logging.getLogger(f"{appname}.{plugin_name}")
sess = "".join(random.choice(string.ascii_letters + string.digits) for i in range(16))

def plugin_start3(plugin_dir: str) -> str:
	global com
	if com: com.up()
	return plugin_name

def plugin_stop() -> None:
	global com
	if com: com.down()
	pass


mute0 = [
"Materials",
"EngineerProgress",
"Statistics",
"ShipLocker",
"Music",
"Cargo",
"Friends",
"Powerplay",
"BuyAmmo",
"RefuelAll",
"Loadout",
]

signals = {
"$MULTIPLAYER_SCENARIO80_TITLE;":"CNB",
"$MULTIPLAYER_SCENARIO42_TITLE;":"NB",
"$MULTIPLAYER_SCENARIO79_TITLE;":"Haz",
"$MULTIPLAYER_SCENARIO78_TITLE;":"Hi",
"$MULTIPLAYER_SCENARIO14_TITLE;":"Med",
"$MULTIPLAYER_SCENARIO77_TITLE;":"Low",
}

ships = {
"adder":"Adder",
"typex":"A. Chieftain",
"typex_3":"A. Challenger",
"typex_2":"A. Crusader",
"anaconda":"Anaconda",
"asp_scout":"Asp Scout",
"asp":"Asp Explorer",
"belugaliner":"Beluga Liner",
"cobramkiii":"Cobra 3",
"cobramkiv":"Cobra 4",
"diamondback":"Diamondback S.",
"diamondbackxl":"Diamondback Ex.",
"dolphin":"Dolphin",
"eagle":"Eagle",
"federation_dropship_mkii":"F. Assault Ship",
"federation_corvette":"F. Corvette",
"ferdelance":"Fer-de-Lance",
"federation_dropship":"F. Dropship",
"federation_gunship":"F. Gunship",
"hauler":"Hauler",
"empire_trader":"Im. Clipper",
"empire_courier":"Im. Courier",
"cutter":"Im. Cutter",
"empire_eagle":"Im. Eagle",
"independant_trader":"Keelback",
"krait_mkii":"Krait 2",
"krait_light":"Krait P.",
"mamba":"Mamba",
"orca":"Orca",
"python":"Python",
"sidewinder":"Sidewinder",
"type6":"Type-6",
"type7":"Type-7",
"type9":"Type-9",
"type9_military":"Type-10",
"viper":"Viper 3",
"viper_mkiv":"Viper 4",
"vulture":"Vulture",
}

frmIntra = None
lblStatus = None
lblAction = None
txtAction = ""
arena = []

def journal_entry(cmdr, is_beta, system, station, entry, state) -> None:
	ev = entry["event"]
	if is_beta or (ev in mute0):
		return
	
	try:
		global plugin_ver
		entry["aver"] = plugin_ver
		v = state["GameVersion"]
		entry["cver"] = int(v[:v.index(".")])
	except:
		return
	
	kws = 0
	job = ""
	cva = ""
	wep = []
	if ("Modules" in state) and (state["Modules"] != None):
		ms = state["Modules"]
		for i,m in ms.items():
			if "Hardpoint" in i and "Item" in m:
				if i.startswith("TinyHardpoint"):
					if m["Item"].startswith("hpt_crimescanner"): kws = 1
				else:
					wep.append(m["Item"])
		if ("PaintJob" in ms) and ("Item" in ms["PaintJob"]): job = ms["PaintJob"]["Item"]
		if ("VesselVoice" in ms) and ("Item" in ms["VesselVoice"]): cva = ms["VesselVoice"]["Item"]
	
	
	entry["cmdr"] = cmdr
	entry["ship"] = state["ShipType"] if "ShipType" in state else ""
	entry["kws"] = kws
	entry["job"] = job
	entry["cva"] = cva
	entry["wep"] = wep
	entry["sess"] = sess
	
	global arena
	global com
	if not com:
		return
	elif ev == "StartUp":
		arena.clear()
		action_set("")
		pass
	elif ev == "FSDJump" or ev == "Location":
		arena.clear()
		action_set("")
		if entry["Population"] < 1:
			return
	elif ev == "FSSSignalDiscovered":
		sig = entry["SignalName"]
		global signals
		if sig in signals:
			if signals[sig] not in arena:
				arena.append(signals[sig])
				sigs = ", ".join(arena)
				action_set(f"System: {sigs}")
		elif not sig.startswith("$Warzone_PointRace_"):
			return
	elif ev == "ShipTargeted":
		if ("Captain" not in state) or (state["Captain"] != None):
			return
		if ("Bounty" not in entry) or ("ScanStage" not in entry) or (entry["ScanStage"] < 3):
			return
	elif ev == "Bounty":
		if ("Captain" not in state) or (state["Captain"] != None):
			action_set("")
			return
		try:
			global ships
			claim = int(entry["TotalReward"])
			ship = ships[entry["Target"]]
			action_set(f"Claim: {claim} {ship}")
		except:
			pass
	else:
		return
	
	com.json(entry)


def plugin_app(parent):
	global frmIntra
	global lblStatus
	global lblAction
	
	frmIntra = tk.Frame(parent, borderwidth=1)
	frmIntra.grid_columnconfigure(0, weight=1)
	frmIntra.bind_all('<<INTRA_Status>>', status_update)
	if com:
		com.tk_element = frmIntra
	
	global status_prefix
	lblStatus = tk.Label(frmIntra, text=status_prefix, anchor=tk.W)
	lblStatus.grid(row=0, column=0, sticky=tk.EW)
	
	lblAction = tk.Label(frmIntra, text="", anchor=tk.W, font=(None, 8))
	lblAction.grid(row=1, column=0, sticky=tk.EW)
	lblAction.bind_all('<<INTRA_Action>>', action_update)
	
	return frmIntra

def status_update(event=None):
	global com
	txt = com.status_pop()
	if txt:
		global lblStatus
		global plugin_ver
		global status_prefix
		update = "; update available" if com.aver and com.aver > plugin_ver else ""
		lblStatus['text'] = f"{status_prefix} {txt}{update}"

def action_set(txt):
	global lblAction
	global txtAction
	txtAction = txt
	lblAction.event_generate("<<INTRA_Action>>", when="tail")

def action_update(event=None):
	global lblAction
	global txtAction
	if txtAction:
		lblAction['text'] = txtAction
	else:
		lblAction['text'] = ""

